/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibModule;
import ibm.nways.jdm.mib.MibRangeSubtype;
import ibm.nways.jdm.mib.MibType;
import ibm.nways.jdm.mib.MibValueSubtype;

public class MibTypeRef
extends MibType {
    private String reference;

    public MibTypeRef(MibModule mibModule) {
        super(mibModule);
        this.reference = null;
    }

    public MibTypeRef(MibModule mibModule, String string) {
        super(mibModule);
        this.reference = string;
    }

    public void modify(String string) {
        this.reference = string;
    }

    public String toString() {
        String string = new String("==>");
        if (this.name != null) {
            string = String.valueOf(string) + this.module.name + "." + this.name + ":";
        }
        if (this.displayHint != null) {
            string = String.valueOf(string) + "[" + this.displayHint + "]";
        }
        if (this.reference != null) {
            string = String.valueOf(string) + this.reference;
        }
        if (this.range != null) {
            string = String.valueOf(string) + this.range.toString();
        }
        string = this.module.containsType(this.reference) ? String.valueOf(string) + "->" + this.module.getType(this.reference).toString() : String.valueOf(string) + "->" + "Unknown";
        return string;
    }

    public MibType getActualType() {
        if (this.module.containsType(this.reference)) {
            return this.module.getType(this.reference).getActualType();
        }
        System.err.println("(1) Warning: Unable to resolve reference to " + this.module.name + "." + this.reference);
        return this;
    }

    public int getTypeEnum() {
        if (this.module.containsType(this.reference)) {
            return this.module.getType(this.reference).getTypeEnum();
        }
        System.err.println("(2) Warning: Unable to resolve reference to " + this.module.name + "." + this.reference);
        return 0;
    }

    public MibRangeSubtype getRangeSubtype() {
        if (this.range != null) {
            return this.range;
        }
        if (this.module.containsType(this.reference)) {
            return this.module.getType(this.reference).getRangeSubtype();
        }
        System.err.println("Warning: Unable to resolve reference to " + this.module.name + "." + this.reference + " when looking for range subtype specification");
        return null;
    }

    public MibValueSubtype getValueSubtype() {
        if (this.allowedValues != null) {
            return this.allowedValues;
        }
        if (this.module.containsType(this.reference)) {
            return this.module.getType(this.reference).getValueSubtype();
        }
        System.err.println("Warning: Unable to resolve reference to " + this.module.name + "." + this.reference + " when looking for value subtype specification");
        return null;
    }

    public String getDisplayHint() {
        if (this.displayHint != null) {
            return this.displayHint;
        }
        if (this.module.containsType(this.reference)) {
            return this.module.getType(this.reference).getDisplayHint();
        }
        return null;
    }
}

